/* hilbert.c -- map between ordinal and point on 2D Hilbert curve.
   Copyright 2000 BitWagon Software LLC.  All rights reserved.
   Licensed under GNU General Public License, version 2; see file COPYING.
*/
#include "hilbert.h"
#include <X11/Xlib.h>

void
hilbert_map(XPoint *point, unsigned j, unsigned w)
{
	unsigned x=0, y=0;
    {
	unsigned bit=1<<0;

	for (w=(1+ w)>>1; 0<w; (bit<<=1), (j>>=2), (--w)) switch (3&j) {
	case 3: {
		unsigned const t = bit -1;
		x |= bit;
		y ^= t;
		x ^= t;
	}  /* fall through */
	case 0: {
		unsigned const t = y; y = x; x = t;
	} break;
	case 2:
		y |= bit;  /* fall through */
	case 1:
		x |= bit;
	}
    }
	point->x = x;
	point->y = y;
}

unsigned int
hilbert_inv(XPoint const *const p, unsigned const width)
{
	unsigned const s21 = (width>>1) -1;
	unsigned n = 0;
	int x = p->x, y = p->y;
	unsigned b1 = 1 <<  s21 ;
	unsigned b2 = 1 << (s21 << 1);
	for (; 0!=b1; b2>>=2, b1>>=1) {
		if (b1 & y) {/* case 2i, case 3i */
			if (0==(b1 & x)) {/* case 3i */
				unsigned const t = y;
				y = ~x;
				x = ~t;
				n += b2;
			}
			n += b2; n += b2;
		}
		else {/* case 0i, case 1i */
			if (b1 & x) {/* case 1i */
				n += b2;
			}
			else {
				unsigned const t = x;
				x = y;
				y = t;
			}
		}
	}
	return n;
}
