# OPTS was collected from output of "rpmbuild -bc glibc.spec"
# after removing the "-s" from:
#     %define silentrules PARALLELMFLAGS=-s

OPTS="-std=gnu99 -fgnu89-inline  -DNDEBUG -O3 -Wall -Winline -Wwrite-strings -fasynchronous-unwind-tables -fmerge-all-constants -frounding-math -g -march=i386 -mno-tls-direct-seg-refs -mtune=generic -Wstrict-prototypes   -fPIC       -I../include -I/home/jreiser/rpmbuild/BUILD/glibc-2.17-c758a686/build-i386-redhat-linux/io -I/home/jreiser/rpmbuild/BUILD/glibc-2.17-c758a686/build-i386-redhat-linux -I../nptl/sysdeps/unix/sysv/linux/i386 -I../nptl/sysdeps/unix/sysv/linux/x86 -I../sysdeps/unix/sysv/linux/x86 -I../sysdeps/unix/sysv/linux/i386/nptl -I../sysdeps/unix/sysv/linux/i386 -I../ports/sysdeps/unix/sysv/linux -I../nptl/sysdeps/unix/sysv/linux -I../nptl/sysdeps/pthread -I../rtkaio/sysdeps/pthread -I../sysdeps/pthread -I../rtkaio/sysdeps/unix/sysv/linux -I../sysdeps/unix/sysv/linux -I../sysdeps/gnu -I../sysdeps/unix/inet -I../ports/sysdeps/unix/sysv -I../nptl/sysdeps/unix/sysv -I../rtkaio/sysdeps/unix/sysv -I../sysdeps/unix/sysv -I../sysdeps/unix/i386 -I../ports/sysdeps/unix -I../nptl/sysdeps/unix -I../rtkaio/sysdeps/unix -I../sysdeps/unix -I../sysdeps/posix -I../sysdeps/i386/fpu -I../sysdeps/x86/fpu -I../nptl/sysdeps/i386 -I../sysdeps/i386 -I../sysdeps/x86 -I../sysdeps/wordsize-32 -I../sysdeps/ieee754/ldbl-96 -I../sysdeps/ieee754/dbl-64 -I../sysdeps/ieee754/flt-32 -I../sysdeps/ieee754 -I../sysdeps/generic -I../ports -I../nptl -I../rtkaio  -I.. -I../libio -I. -nostdinc -isystem /usr/lib/gcc/i686-redhat-linux/4.8.0/include -isystem /usr/include  -D_LIBC_REENTRANT -DNO_TLS_DIRECT_SEG_REFS -include ../include/libc-symbols.h  -DPIC -DSHARED"

set -x
set -e

# You will need to run "rpmbuild -bc glibc.spec" first, in order to have
# config.h etc.
#
# The LD_PRELOAD override library  matters only on i686(i386), not on x86_64.
#
CC="gcc -m32"
RPMBUILD=${RPMBUILD:=$HOME/rpmbuild}
DIR=$RPMBUILD/BUILD/glibc-2.17-c758a686/io
cd $DIR

# glibc source assumes that it is executing inside glibc,
# but the overriding .so will execute outside of glibc.
# Therefore we must undo the assumption that getenv(), fprintf(), and abort()
# are internal to the override.

file=xstatconv
sed -e '/^#include <errno.h>/a\
#undef __set_errno\
#define __set_errno(val) xstat32_set_errno(val);\
extern void xstat32_set_errno(int);\
'  <../sysdeps/unix/sysv/linux/$file.c  >$file-1.c
$CC -E $OPTS $file-1.c  |
    sed  >$file-2.c  \
	-e '/__GI_getenv/s|.*|/*&*/|' -e '/__GI_fprintf/s|.*|/*&*/|' -e '/__GI_abort/s|.*|/*&*/|'
$CC -c $file-2.c -o $file.os $OPTS
#rm -f $file-1.c $file-2.c


# Also, __set_errno() must take a detour in order to access the correct location.
#
cat >xstat32_set_errno.c <<EOF
#include <errno.h>
void xstat32_set_errno(int val) { errno = val; }
EOF
$CC -c xstat32_set_errno.c -o xstat32_set_errno.os -fPIC


# The worker routines
#
for file in fxstat fxstatat lxstat xstat
do
    base=${file##*/}
    sed  <../sysdeps/unix/sysv/linux/i386/$base.c  >$base-1.c \
	-e '/^#include <errno.h>/a\
#undef __set_errno\
#define __set_errno(val) xstat32_set_errno(val);\
extern void xstat32_set_errno(int);\
'	-e '/hidden_def (/s|.*|/*&*/|' \
	-e '/weak_alias (/s|.*|/*&*/|'
    $CC -E $base-1.c $OPTS  |  sed  >$base-2.c \
	-e '/extern __typeof (__'$base') __'$base' __asm__ ("" "__GI___'$base'") __attribute__ ((visibility ("hidden")));/s|.*|/*&*/|'
    $CC -c $base-2.c -o $base.os $OPTS
    #rm -f $base-1.c $base-2.c
done


ld -m elf_i386 -shared \
	--version-script=$HOME/xstat32_EOVERFLOW.versions \
	-o xstat32_EOVERFLOW.so \
	-soname=xstat32_EOVERFLOW \
	fxstat.os fxstatat.os lxstat.os xstat.os xstatconv.os xstat32_set_errno.os
#rm -f   fxstat.os fxstatat.os lxstat.os xstat.os xstatconv.os xstat32_set_errno.os
